
appModule.service('pages', ['native','Notice_Constant', function (native,noticeConstant) {
    var scopes = {};
    var cbs = {};
    var functionId = 0;
    var isWindows = native.isWindowsOS();

    if (!isWindows) {
        native.bindGlobalEvent('onResponseOSType', function (eventData) {
            if (eventData && eventData.detail && eventData.detail.data) {
                isWindows = eventData.detail.data.isWindows;
            }

            native.unbindGlobalEvent('onResponseOSType', arguments.callee);
        });
        native.triggerGlobalEvent('onRequestOSType');
    }

    function windowFnHandler(e) {
        var data = e.detail.data;
        scopes[data.windowName] && scopes[data.windowName][data.fnName] && scopes[data.windowName][data.fnName](data.params, function (rlt) {
            native.triggerGlobalEvent('subWindowCallback', {
                fnName: data.fnName,
                data: rlt,
                windowName: data.windowName,
                fnId: data.fnId
            });
        });
    }

    function windowFnCallbackHandler(e) {
        var data = e.detail.data;
        cbs[data.fnId] && cbs[data.fnId](data.data);
        delete cbs[data.fnId];
    }

    native.bindGlobalEvent('subWindowFn', windowFnHandler);

    native.bindGlobalEvent('subWindowCallback', windowFnCallbackHandler);

    return {
        openModalDialog: function (url, eventName, width, height, scope, cOptions,isAbsolutePath) {
            var option = !cOptions ? {} : cOptions;
            option.caption = option.caption || [{
                    left: 20,
                    top: 5,
                    width: -90,
                    height: 40
                }, {
                    left: 0,
                    top: 0,
                    width: 20,
                    height: -20
                }];
            if (option.macResolution && !isWindows) {
                width = option.macResolution.width;
                height = option.macResolution.height;
            }

            var options = {
                width: width,
                height: height,
                refreshIfExist: false,
                centerScreen: true,
                modal: true,
                resizable: true,
                minWidth: width,
                minHeight: height
            };
            var WindowShadowWidth = {
                Top: 5,
                Left: 15,
                Right: 15,
                Bottom: 15
            };
            if (!option.removeBorder && isWindows) {
                options.width = options.width + WindowShadowWidth.Left + WindowShadowWidth.Right;
                options.height = options.height + WindowShadowWidth.Top + WindowShadowWidth.Bottom;
                options.minWidth = options.minWidth ? options.minWidth + WindowShadowWidth.Left + WindowShadowWidth.Right : options.width;
                options.minHeight = options.minHeight ? options.minHeight + WindowShadowWidth.Top + WindowShadowWidth.Bottom : options.height;
                options.borderSpace = {
                    leftBorder: WindowShadowWidth.Left,
                    topBorder: WindowShadowWidth.Top,
                    rightBorder: WindowShadowWidth.Right,
                    bottomBorder: WindowShadowWidth.Bottom
                };
            }

            if(!isAbsolutePath){
                var rootPath = location.pathname.match(/notice\/(.*)/gi)[0];
                var currentPage = rootPath.substr(rootPath.lastIndexOf("/") + 1);
                url = rootPath.replace(currentPage, url);
            }


            native.openWindow(url, eventName, $.extend({
                title: eventName,
                left: 0,
                top: 0,
                width: 0,
                height: 0,
                refreshIfExist: false,
                centerScreen: true,
                modal: true,
                resizable: true,
                minWidth: 200,
                minHeight: 200,
                isTop: false,
                enableDrag: false,
                hasTaskBarIcon: true,
                behaviorIfSCClose: 0,
                isChild: false,
                isShow: true,
                isLayered: option.isLayered == undefined ? (isWindows) : option.isLayered,
                showCloseButton: false,
                showMinimalButton: false,
                showFullScreenButton: false
            }, options, option));
            if (scope) {
                scopes[eventName] = scope;
                scope.$on('$destroy', function () {
                    delete scopes[eventName];
                });
            }
        },
        fnCall: function (windowName, fnName, params, cb) {
            functionId++;
            native.triggerGlobalEvent('subWindowFn', {
                windowName: windowName,
                fnName: fnName,
                params: params,
                fnId: windowName + functionId
            });
            if (!!cb) {
                cbs[windowName + functionId] = cb;
            }
        },
        closeWindow: function () {
            native.unbindDefaultEvent(windowFnHandler, windowFnCallbackHandler);
            native.closeWindow();
        },
        maximizeWindow: function () {//最大化窗口
            native.maximizeWindow();
        },
        restoreWindow: function () {//恢复当前窗口大小
            native.restoreWindow();
        },
        minimizeWindow: function () {//最小化当前窗口
            native.minimizeWindow();
        },
        setWindowToTop: function () {
            native.setTop(true);
            native.setTop(false);
        },
        backToMain: function () {
            native.hideNoticePanel();
        },
        backToConversation: function () {
            native.goToConversation();
        },
        attachEventScope: function (windowName, scope) {
            scopes[windowName] = scope;
        },
        detachEventScope: function (windowName) {
            delete scopes[windowName];
        },
        bindGlobalEvent: function (name, handler) {
            native.bindGlobalEvent(name, handler);
        },
        unbindGlobalEvent: function (name, handler) {
            native.unbindGlobalEvent(name, handler);
        },
        triggerCrossWindowEvent: function (name, param) {
            native.triggerGlobalEvent(name, param);
        },
        addWindowRestoreListener: function (handler) {
            native.bindWindowRestoreEvent(handler);
        },
        removeWindowRestoreListener: function (handler) {
            native.unbindWindowRestoreEvent(handler);
        },
        addWindowMaxListener: function (handler) {
            native.bindWindowMaxListener(handler);
        },
        removeWindowMaxListener: function (handler) {
            native.unbindWindowMaxEvent(handler);
        },
        addWindowCloseListener:function(handler){
            native.bindWindowCloseListener(handler);
        },
        removeWindowCloseListener:function(){
            native.unbindWindowCloseEvent();
        },
        showFileTransferModule: function () {
            native.showFileTransferModule();
        },
        isHidden: function () {
            return native.pageIsHidden();
        },
        openPreviewWindow:function(urlList,url){
            var width = noticeConstant.PreviewWindow.DefaultWidth;
            var height = noticeConstant.PreviewWindow.DefaultHeight;
            var position = {
                left: (window.screen.availWidth - width) / 2,
                top: (window.screen.availHeight - height) / 2
            };
            var options = {
                title: 'preview image',
                width: width, //uc.constants.UI.ImagePreviewWindow.Width, //screen.availWidth,
                height: height, //uc.constants.UI.ImagePreviewWindow.Height, //screen.availHeight,
                left: position.left,
                top: position.top,
                isTop: false,
                isShow: true,
                refreshIfExist: true,
                centerScreen: true, //uc.getOSType() == uc.constants.OSType.Mac,
                modal: false,
                resizable: true,
                minWidth: noticeConstant.PreviewWindow.MinWidth,//screen.availWidth,
                minHeight: noticeConstant.PreviewWindow.MinHeight,//screen.availHeight,
                behaviorIfSCClose: 0,
                hasTaskBarIcon: true,
                borderSpace: {
                    leftBorder: 0,
                    topBorder: 0,
                    rightBorder: 0,
                    bottomBorder: 0
                },
                isChild: false,
                removeBorder: false,
                isLayered: false,
                showCloseButton: true,
                showMinimalButton: true,
                showFullScreenButton: true,
                caption: noticeConstant.Caption.PreviewWindow,
                enableDrag: true
            };

            top.localStorage.setItem('image-preview-data',JSON.stringify({
                imageList: urlList,
                imagePath: url,
                type:'notice'
            }));
            this.openModalDialog('page/imagePreviewer.html','imagePreviewer',screen.availWidth,screen.availHeight,null,options,true);
        }
    };
}]);
